'use strict';
/* Data Access Object (DAO) module for accessing db. 
Le API hanno gli stessi nome delle API Python, rifarsi a dbAPI.py per la documentazione */

const db = require('./db');

// ritorna tutte le fasce orarie possibili
exports.get_fasceOrarie = () => {
    return new Promise((resolve, reject) => {
        const sql = 'SELECT DISTINCT fasciaOraria FROM SlotSettimana';
        db.all(sql, [], (err, rows) => {
            if (err) {
                reject(err);
                return;
            }
            const listFasce = rows.map((fascia) => ({
                fasciaOraria: fascia.fasciaOraria
            }));
            resolve(listFasce);
        })
    })
}

exports.get_giorni = () => {
    return new Promise((resolve, reject) => {
        const sql = 'SELECT DISTINCT giorno FROM SlotSettimana ORDER BY giorno ASC';
        db.all(sql, [], (err, rows) => {
            if (err) {
                reject(err);
                return;
            }
            const listGiorni = rows.map((g) => ({
                giorno: g.giorno
            }));
            resolve(listGiorni);
        })
    })
}

exports.get_docenti = () => {
    return new Promise((resolve, reject) => {
        // non sono sicuro della correttezza di Docente
        const sql = 'SELECT DISTINCT Cognome FROM Docente_in_Slot';
        db.all(sql, [], (err, rows) => {
            if (err) {
                reject(err);
                return;
            }
            const listDoc = rows.map((doc) => ({
                Cognome: doc.Cognome
            }));
            resolve(listDoc);
        })
    })
}

exports.get_Insegnamenti = () => {
    return new Promise((resolve, reject) => {
        const sql = 'SELECT * FROM Insegnamento';
        db.all(sql, [], (err, rows) => {
            if (err) {
                reject(err);
                return;
            }
            const listIns = rows.map((ins) => ({
                ID_INC: ins.ID_INC, nStudenti: ins.nStudenti, nStudentiFreq: ins.nStudentiFreq, collegio: ins.collegio, titolo: ins.titolo,
                CFU: ins.CFU, oreLez: ins.oreLez, titolare: ins.titolare
            }));
            resolve(listIns);
        });
    });
}

exports.get_PianoAllocazione = () => {
    return new Promise((resolve, reject) => {
        const sql = 'SELECT * FROM PianoAllocazione'
        db.all(sql, [], (err, rows) => {
            if (err) {
                reject(err);
                return;
            }
            const listPiani = rows.map((piano) => ({
                pianoAllocazione: piano.pianoAllocazione
            }));
            resolve(listPiani);
        })
    })
}

exports.get_Insegnamenti_withOrientamento = (orientamento, nomeCdl, tipoCdl) => {
    return new Promise((resolve, reject) => {
        const sql = "SELECT I.ID_INC, I.nStudenti, I.nStudentiFreq, I.collegio, \
        I.titolo, I.CFU, I.oreLez, I.titolare, IiO.nStudenti AS nStudentiOrient, IiO.tipoInsegnamento, IiO.periodoDidattico, IiO.alfabetica \
                    FROM Insegnamento_in_Orientamento IiO, Insegnamento I \
                    WHERE IiO.ID_INC = I.ID_INC AND IiO.orientamento = ? AND IiO.nomeCdl = ? AND Iio.tipoCdl = ?";
        db.all(sql, [orientamento, nomeCdl, tipoCdl], (err, rows) => {
            if (err) {
                reject(err);
                return;
            }
            const listIns = rows.map((ins) => ({
                ID_INC: ins.ID_INC, nStudenti: ins.nStudenti, nStudentiFreq: ins.nStudentiFreq, collegio: ins.collegio, titolo: ins.titolo,
                CFU: ins.CFU, oreLez: ins.oreLez, titolare: ins.titolare, nStudentiOrient: ins.nStudentiOrient,
                tipoInsegnamento: ins.tipoInsegnamento, periodoDidattico: ins.periodoDidattico, alfabetica: ins.alfabetica
            }));
            resolve(listIns);
        })
    })
}

exports.get_pianoAllocazioneID_INC_withDocenti = (pianoAllocazione, ID_INC) => {
    return new Promise((resolve, reject) => {
        const sql = "SELECT * \
                    FROM Slot S, Docente_in_Slot DiS \
                    WHERE S.pianoAllocazione = ? AND S.ID_INC = ? AND S.idSlot = DiS.idSlot AND S.pianoAllocazione = DiS.pianoAllocazione \
                    ORDER BY S.idSlot";
        db.all(sql, [pianoAllocazione, ID_INC], (err, rows) => {
            if (err) {
                reject(err);
                return;
            }
            const slots = rows.map((slot) => ({
                pianoAllocazione: slot.pianoAllocazione, idSlot: slot.idSlot, nStudentiAssegnati: slot.nStudentiAssegnati,
                tipoLez: slot.tipoLez, numSlotConsecutivi: slot.numSlotConsecutivi, ID_INC: slot.ID_INC, giorno: slot.giorno,
                fasciaOraria: slot.fasciaOraria, tipoLocale: slot.tipoLocale, tipoErogazione: slot.tipoErogazione, Cognome: slot.Cognome
            }));
            resolve(slots);
        })
    })
}

exports.get_pianoAllocazioneOrientamento_withDocenti = (pianoAllocazione, tipoCdl, nomeCdl, orientamento, periodoDidattico) => {
    return new Promise((resolve, reject) => {
        const sql = "SELECT * \
                    FROM Slot S, Docente_in_Slot DiS, Insegnamento I, Insegnamento_in_Orientamento IiO \
                    WHERE S.idSlot = DiS.idSlot AND S.pianoAllocazione = DiS.pianoAllocazione AND I.ID_INC = S.ID_INC AND IiO.ID_INC = I.ID_INC \
                    AND S.pianoAllocazione = ? AND IiO.periodoDidattico = ? AND IiO.orientamento = ? AND IiO.nomeCdl = ? AND IiO.tipoCdl = ? \
                    ORDER BY S.idSlot";
        db.all(sql, [pianoAllocazione, periodoDidattico, orientamento, nomeCdl, tipoCdl], (err, rows) => {
            if (err) {
                reject(err);
                return;
            }
            const slots = rows.map((slot) => ({
                pianoAllocazione: slot.pianoAllocazione, idSlot: slot.idSlot, nStudentiAssegnati: slot.nStudentiAssegnati,
                tipoLez: slot.tipoLez, numSlotConsecutivi: slot.numSlotConsecutivi, ID_INC: slot.ID_INC, giorno: slot.giorno,
                fasciaOraria: slot.fasciaOraria, tipoLocale: slot.tipoLocale, tipoErogazione: slot.tipoErogazione, Cognome: slot.Cognome,
                tipoInsegnamento: slot.tipoInsegnamento,
                // per assegnare anche l'Insegnamento
                nStudenti: slot.nStudenti, nStudentiFreq: slot.nStudentiFreq, collegio: slot.collegio, titolo: slot.titolo, CFU: slot.CFU,
                oreLez: slot.oreLez, titolare: slot.titolare, nStudentiOrient: slot.nStudentiOrient, alfabetica: slot.alfabetica
            }));
            resolve(slots);
        })
    })
}

exports.get_pianoAllocazioneDocente = (pianoAllocazione, docente) => {
    return new Promise((resolve, reject) => {
        const sql = "SELECT S.pianoAllocazione, S.idSlot, S.nStudentiAssegnati, S.tipoLez, S.numSlotConsecutivi, S.ID_INC, S.giorno, \
                        S.fasciaOraria, S.tipoLocale, S.tipoErogazione, DiS.Cognome, I.nStudenti, I.nStudentiFreq, I.collegio, I.titolo, \
                        I.CFU, I.oreLez, I.titolare \
                    FROM Docente_in_Slot DiS, Slot S, Insegnamento I \
                    WHERE S.idSlot = DiS.idSlot AND S.pianoAllocazione = DiS.pianoAllocazione AND I.ID_INC = S.ID_INC \
                    AND S.pianoAllocazione = ? AND DiS.Cognome = ? \
                    ORDER BY S.idSlot";
        db.all(sql, [pianoAllocazione, docente], (err, rows) => {
            if (err) {
                reject(err);
                return;
            }
            const slots = rows.map((slot) => ({
                pianoAllocazione: slot.pianoAllocazione, idSlot: slot.idSlot, nStudentiAssegnati: slot.nStudentiAssegnati,
                tipoLez: slot.tipoLez, numSlotConsecutivi: slot.numSlotConsecutivi, ID_INC: slot.ID_INC, giorno: slot.giorno,
                fasciaOraria: slot.fasciaOraria, tipoLocale: slot.tipoLocale, tipoErogazione: slot.tipoErogazione, Cognome: slot.Cognome,
                // Insegnamento
                nStudenti: slot.nStudenti, nStudentiFreq: slot.nStudentiFreq, collegio: slot.collegio, titolo: slot.titolo, CFU: slot.CFU,
                oreLez: slot.oreLez, titolare: slot.titolare
            }));

            resolve(slots);
        })
    })
}

exports.get_corsiDiLaurea_withTipoCdl = (tipoCdl) => {
    return new Promise((resolve, reject) => {
        const sql = "SELECT * FROM Corso_di_laurea WHERE tipoCdl = ?";
        db.all(sql, [tipoCdl], (err, rows) => {
            if (err) {
                reject(err);
                return;
            }
            const listCdl = rows.map((cdl) => ({
                tipoCdl: cdl.tipoCdl, nomeCdl: cdl.nomeCdl
            }));
            resolve(listCdl);
        })
    })
}

exports.get_corsiDiLaurea = () => {
    return new Promise((resolve, reject) => {
        const sql = "SELECT * FROM Corso_di_laurea";
        db.all(sql, [], (err, rows) => {
            if (err) {
                reject(err);
                return;
            }
            const listCdl = rows.map((cdl) => ({
                tipoCdl: cdl.tipoCdl, nomeCdl: cdl.nomeCdl
            }));
            resolve(listCdl);
        })
    })
}

exports.get_Orientamenti = () => {
    return new Promise((resolve, reject) => {
        const sql = "SELECT * FROM Orientamento";
        db.all(sql, [], (err, rows) => {
            if (err) {
                reject(err);
                return;
            }
            const listOrient = rows.map((orient) => ({
                orientamento: orient.orientamento, nomeCdl: orient.nomeCdl, tipoCdl: orient.tipoCdl
            }));
            resolve(listOrient);
        })
    })
}

exports.get_Orientamenti_Cdl = (nomeCdl, tipoCdl) => {
    return new Promise((resolve, reject) => {
        const sql = "SELECT * FROM Orientamento WHERE nomeCdl = ? AND tipoCdl = ?";
        db.all(sql, [nomeCdl, tipoCdl], (err, rows) => {
            if (err) {
                reject(err);
                return;
            }
            const listOrient = rows.map((orient) => ({
                orientamento: orient.orientamento, nomeCdl: orient.nomeCdl, tipoCdl: orient.tipoCdl
            }));
            resolve(listOrient);
        })
    })
}

